/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.sonarlint.core.container.analysis;

import org.sonar.api.batch.rule.CheckFactory;
import org.sonar.api.issue.NoSonarFilter;
import org.sonar.api.resources.Languages;
import org.sonar.api.resources.Project;
import org.sonar.api.scan.filesystem.FileExclusions;
import org.sonar.api.scan.filesystem.PathResolver;
import org.sonar.api.utils.log.Logger;
import org.sonar.api.utils.log.Loggers;
import org.sonarsource.sonarlint.core.analyzer.issue.IssuableFactory;
import org.sonarsource.sonarlint.core.analyzer.issue.IssueFilters;
import org.sonarsource.sonarlint.core.analyzer.noop.NoOpFileLinesContextFactory;
import org.sonarsource.sonarlint.core.analyzer.noop.NoOpHighlightableBuilder;
import org.sonarsource.sonarlint.core.analyzer.noop.NoOpSymbolizableBuilder;
import org.sonarsource.sonarlint.core.analyzer.noop.NoOpTestPlanBuilder;
import org.sonarsource.sonarlint.core.analyzer.noop.NoOpTestableBuilder;
import org.sonarsource.sonarlint.core.analyzer.perspectives.BatchPerspectives;
import org.sonarsource.sonarlint.core.analyzer.sensor.BatchExtensionDictionnary;
import org.sonarsource.sonarlint.core.analyzer.sensor.DefaultSensorContext;
import org.sonarsource.sonarlint.core.analyzer.sensor.DefaultSensorStorage;
import org.sonarsource.sonarlint.core.analyzer.sensor.LtsApiSensorContext;
import org.sonarsource.sonarlint.core.analyzer.sensor.PhaseExecutor;
import org.sonarsource.sonarlint.core.analyzer.sensor.SensorOptimizer;
import org.sonarsource.sonarlint.core.analyzer.sensor.SensorsExecutor;
import org.sonarsource.sonarlint.core.container.ComponentContainer;
import org.sonarsource.sonarlint.core.container.analysis.AnalysisSettings;
import org.sonarsource.sonarlint.core.container.analysis.AnalysisTempFolderProvider;
import org.sonarsource.sonarlint.core.container.analysis.ProjectProvider;
import org.sonarsource.sonarlint.core.container.analysis.filesystem.DefaultLanguagesRepository;
import org.sonarsource.sonarlint.core.container.analysis.filesystem.FileIndexer;
import org.sonarsource.sonarlint.core.container.analysis.filesystem.FileMetadata;
import org.sonarsource.sonarlint.core.container.analysis.filesystem.InputFileBuilder;
import org.sonarsource.sonarlint.core.container.analysis.filesystem.InputPathCache;
import org.sonarsource.sonarlint.core.container.analysis.filesystem.LanguageDetection;
import org.sonarsource.sonarlint.core.container.analysis.filesystem.SonarLintFileSystem;
import org.sonarsource.sonarlint.core.container.global.ExtensionInstaller;
import org.sonarsource.sonarlint.core.container.global.ExtensionMatcher;
import org.sonarsource.sonarlint.core.container.global.ExtensionUtils;

public class AnalysisContainer
extends ComponentContainer {
    private static final Logger LOG = Loggers.get(AnalysisContainer.class);

    public AnalysisContainer(ComponentContainer globalContainer) {
        super(globalContainer);
    }

    @Override
    protected void doBeforeStart() {
        this.addBatchComponents();
        this.addBatchExtensions();
    }

    private void addBatchComponents() {
        this.add(new ProjectProvider(), NoOpFileLinesContextFactory.class, new AnalysisTempFolderProvider(), PathResolver.class, NoOpTestPlanBuilder.class, NoOpTestableBuilder.class, Languages.class, DefaultLanguagesRepository.class, AnalysisSettings.class, PhaseExecutor.class, SensorsExecutor.class, InputPathCache.class, FileExclusions.class, InputFileBuilder.class, FileMetadata.class, LanguageDetection.class, FileIndexer.class, SonarLintFileSystem.class, SensorOptimizer.class, DefaultSensorContext.class, DefaultSensorStorage.class, LtsApiSensorContext.class, BatchExtensionDictionnary.class, IssueFilters.class, CheckFactory.class, IssuableFactory.class, NoSonarFilter.class, BatchPerspectives.class, NoOpHighlightableBuilder.class, NoOpSymbolizableBuilder.class);
    }

    private void addBatchExtensions() {
        this.getComponentByType(ExtensionInstaller.class).install(this, new BatchExtensionFilter());
    }

    @Override
    protected void doAfterStart() {
        LOG.debug("Start analysis");
        Project p = this.getComponentByType(Project.class);
        this.getComponentByType(PhaseExecutor.class).execute(p);
    }

    static class BatchExtensionFilter
    implements ExtensionMatcher {
        BatchExtensionFilter() {
        }

        @Override
        public boolean accept(Object extension) {
            return ExtensionUtils.isBatchSide(extension) && (ExtensionUtils.isInstantiationStrategy(extension, "PER_BATCH") || ExtensionUtils.isInstantiationStrategy(extension, "PER_PROJECT"));
        }
    }
}

